<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    exit(0);
}

require_once 'auth.php';
start_secure_session();

$request_uri = explode('?', $_SERVER['REQUEST_URI'], 2);
$path = trim($request_uri[0], '/');
$segments = explode('/', $path);
$endpoint = $segments[3] ?? null;
$method = $_SERVER['REQUEST_METHOD'];
$data = json_decode(file_get_contents('php://input'), true);

$response = ['success' => false, 'message' => 'Invalid endpoint.'];

if ($endpoint) {
    switch ($endpoint) {
        case 'register':
            if ($method == 'POST')
                $response = register_user($data);
            break;
        case 'login':
            if ($method == 'POST')
                $response = login_user($data);
            break;
        case 'logout':
            if ($method == 'POST') {
                if (isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true) {
                    $response = logout_user();
                } else {
                    $response = ['success' => false, 'message' => 'Not logged in.'];
                    http_response_code(401);
                }
            }
            break;
        // This is a new test endpoint for debugging
        case 'test':
            $response = ['success' => true, 'message' => 'API is working!'];
            break;
    }
}

echo json_encode($response);
?>